;*******************************************************************************
;*  2x16-os alfanumerikus kijelz? s 4x4-es gombmtrix vezrl?, egyedi 1-wire  *
;*  kommunikcival.                                                           *
;*******************************************************************************
	
	;Tartalom
;--Inicializls--	
;--Kijelz? ttltse--	
;--Gombok beolvassa a mtrixbl--	
;--Adatkezels--
;--Szveg vtele, feldolgozsa--
;--Karakter vtele, feldolgozsa--
;--Egyedi karakterek fogadsa, feltltse--
;--Gombinformcik elkldse--	
;--Fnyer? vltoztats--
;--LCD ki--	
;--Kijelz? inicializlsa--
;--Kirs rutin--
;--dvzl? szveg--
;--Az ad oldal m?kdse:--
	
	LIST	P=PIC18F14K22	; lista megadsa
	INCLUDE	<P18F14K22.INC>	; includde fjlok megadsa
	RADIX	hex				; alaprtelmezet szmrendszer megadsa

	CONFIG	FOSC = IRC		; bels? oszcilltor
	CONFIG	WDTEN = OFF	        ; watchdog bekapcsolsa
	CONFIG	LVP = OFF		; alacsony feszltsg? programozs kikapcsolva
	CONFIG  MCLRE = OFF 
	
	CBLOCK	0x0070
	BK_1                  ;Els? lenyomott bill. szma.
	BK_2                  ;Msodik lenyomott bill. szma.
	BK_3                  ;Harmadik lenyomott bill. szma.
	BKT_1                 ;\
	BKT_2                 ; El?z? vizsglati rtkek
	BKT_3                 ;/
	KESLELTETES           ; Kirs id?zt?je
	KAR_KOD               ; Kiirand karakter kdja
	CIKLUS 
	BYTE
	TESZT_IDO,HE1,HE2,HE3,HE4,HE5,BONTANDOU,BONTANDOH,BONTANDOL,LIGHT
	ENDC
#define	    IN	    BSF
#define	    OUT	    BCF
#define	    ON	    BSF
#define	    OFF	    BCF	
#define	    LCD		LATA,2
#define	    UTASITAS	BCF LATC,0
#define	    ADAT	BSF LATC,0
#define	    ENABLE	LATC,1


DELAY	MACRO	SZAMLALO_INDUL
	MOVLW	SZAMLALO_INDUL
	MOVWF	KESLELTETES
	DECFSZ	KESLELTETES
	GOTO	$-2
	ENDM	
WAIT_1US   MACRO   MENNYI
	MOVLW	MENNYI
	DECFSZ	WREG
	GOTO	$-2
	ENDM	
HA_ON	MACRO   MI,MELYIK,HOVA
	BTFSC	MI,MELYIK
	GOTO	HOVA
	ENDM
HA_OFF	MACRO	MI,MELYIK,HOVA
	BTFSS	MI,MELYIK
	GOTO	HOVA
	ENDM		
KAPCSOL	MACRO	MI,MELYIK,MIRE
	MIRE	MI,MELYIK
	ENDM
MOV MACRO HOVA,MIT
	MOVLW   MIT
	MOVFF   WREG,HOVA
	ENDM
BILL_ERTEK  MACRO MENNYI
	MOVFF	BK_2,BK_3
	MOVFF	BK_1,BK_2
	MOVLW	MENNYI
	MOVWF	BK_1
	ENDM
SZAMBONTAS  MACRO   MIT_U,MIT_H,MIT_L
	GOTO	$+6
	GOTO	$+0x16
	MOVFF	MIT_U,BONTANDOU
	MOVFF	MIT_H,BONTANDOH
	MOVFF	MIT_L,BONTANDOL
	CALL	SZAMBONTAS_16
	ENDM
	
	
	org		0x0000			 ;Program memria kezd cme
	nop						 ;ICD miatt
    GOTO    INICIALIZALAS
    nop
	org		0x0008
    nop
    GOTO    MEGSZAKITAS
    nop	
;-------------------------------Inicializls-----------------------------------    
INICIALIZALAS
    CLRF    TMR0
    CLRF    LATA
    CLRF    LATB
    CLRF    LATC
    CLRF    ANSEL
    CLRF    ANSELH 
    MOV	    OSCCON,B'00010010'
    MOVLW   D'10'
    MOVWF   KESLELTETES   
    INCFSZ  CIKLUS
    GOTO    $-2
    DECFSZ  KESLELTETES
    GOTO    $-8
    MOV	    TRISA,B'00111001'
    MOV	    TRISB,B'00000000'
    MOV	    TRISC,B'00100000'  
    MOV	    OSCCON,B'01000010'    
    MOV	    T2CON,B'00000100'
    MOV	    CCP1CON,B'00001100'	
    MOV	    T0CON,B'11000111'
    MOV	    INTCON,B'11100000'
    MOV	    PR2,0xFF
    MOV	    CCPR1L,0xA0    
    CLRF    PSTRCON    
    CLRF    TESZT_IDO
    CALL    LCD_INI
    CALL    UDVOZLOSZOVEG
    MOV	    CIKLUS,D'70'    ;Ciklusszmll feltltse    
    MOVLW   0x25
    MOVWF   FSR1L
    CLRF    FSR1H           ;Trol trlse
    MOVLW   0x14
    MOVWF   POSTINC1
    DECFSZ  CIKLUS
    GOTO    $-4
    GOTO    MAIN   ;?
;------------------------Gombok beolvassa a mtrixbl--------------------------
MAIN
    ON	    LATA,1    
    MOVLW   20
    MOVWF   BK_1
    MOVWF   BK_2
    MOVWF   BK_3
    OFF	    LATC,7
    OFF	    LATC,6
    OFF	    LATC,3
    ON	    LATC,4
    HA_OFF  PORTC,5,$+0x10
    BILL_ERTEK	0x33
    HA_OFF  PORTA,3,$+0x10
    BILL_ERTEK	0x32    
    HA_OFF  PORTA,4,$+0x10
    BILL_ERTEK	0x31  
    HA_OFF  PORTA,5,$+0x10
    BILL_ERTEK	0x2B   
    OFF	    LATC,7
    OFF	    LATC,6
    ON	    LATC,3
    OFF	    LATC,4
    HA_OFF  PORTC,5,$+0x10
    BILL_ERTEK	0x36
    HA_OFF  PORTA,3,$+0x10
    BILL_ERTEK	0x35    
    HA_OFF  PORTA,4,$+0x10
    BILL_ERTEK	0x34   
    HA_OFF  PORTA,5,$+0x10
    BILL_ERTEK	0x2E     
    OFF	    LATC,7
    ON	    LATC,6
    OFF	    LATC,3
    OFF	    LATC,4
    HA_OFF  PORTC,5,$+0x10
    BILL_ERTEK	0x39
    HA_OFF  PORTA,3,$+0x10
    BILL_ERTEK	0x38    
    HA_OFF  PORTA,4,$+0x10
    BILL_ERTEK	0x37   
    HA_OFF  PORTA,5,$+0x10
    BILL_ERTEK	0x2D     
    ON	    LATC,7
    OFF	    LATC,6
    OFF	    LATC,3
    OFF	    LATC,4
    HA_OFF  PORTC,5,$+0x10
    BILL_ERTEK	0x23
    HA_OFF  PORTA,3,$+0x10
    BILL_ERTEK	0x30    
    HA_OFF  PORTA,4,$+0x10
    BILL_ERTEK	0x2A   
    HA_OFF  PORTA,5,$+0x10
    BILL_ERTEK	0x2C     
    MOVFF   BK_1,BKT_1
    MOVFF   BK_2,BKT_2
    MOVFF   BK_3,BKT_3
    MOVLW   D'200'
    CPFSLT  TESZT_IDO
    CALL    GOMB_KIIR
;--------------------------------Kijelz? ttltse------------------------------
    HA_OFF  LCD,VARAKOZAS 
    MOVLW   0x01
    MOVWF   FSR0L
    CLRF    FSR0H
    UTASITAS                   ;------------------------------------------------
    MOVLW   B'10000000'        ;Ez a rutin tkapcsolja a kijelz?t utasts 
    CALL    KIIRAS             ;fogadsra, belltja a kijelz? fels? sornak 
    MOV	    CIKLUS,D'16'       ;kezd?rtkt, s feltlti a ciklusszmllt.
    ADAT                       ;Visszakapcsolja a kijelz?t adat fogadsra.
FELSO_SOR    
    MOVF    POSTINC0,W
    CALL    KIIRAS
    DECFSZ  CIKLUS
    GOTO    FELSO_SOR
    UTASITAS                   ;------------------------------------------------
    MOVLW   B'11000000'        ;Ez a rutin tkapcsolja a kijelz?t utasts 
    CALL    KIIRAS             ;fogadsra, belltja a kijelz? als sornak 
    MOV	    CIKLUS,D'16'       ;kezd?rtkt, s feltlti a ciklusszmllt.
    ADAT                       ;Visszakapcsolja a kijelz?t adat fogadsra.
ALSO_SOR     
    MOVF    POSTINC0,W
    CALL    KIIRAS
    DECFSZ  CIKLUS
    GOTO    ALSO_SOR
VARAKOZAS
    BTFSC   PORTA,0        ;Ennl a vrakozsi ciklusnl, ha kb 50msec-ig nem 
    GOTO    VARAKOZAS      ;rkezik jel, bekvetkezik egy reset.
    MOVLW   D'200'
    CPFSGT  TESZT_IDO
    INCF    TESZT_IDO
;-------------------------------Adatkezels-------------------------------------    
    CLRF    TMR0
    MOV	    OSCCON,B'01110010' ;rajel felgyorstsa
    BTFSS   PORTA,0        ;Vrakozs a jel megsz?nsre
    GOTO    $-2
    CLRF    TESZT_IDO
    OFF     LATA,1         ;Visszaigazols (adatvonalat L-be hzza)
    WAIT_1US	D'30'      ;30usec vrakozs
    ON	    LATA,1
    MOV	    CIKLUS,D'8'    ;Ciklusszmll feltltse
    ;--------------
UT_VAR                     ;Utasts byte fogadsa
    BTFSC   PORTA,0
    GOTO    $-2            ;Vrakozs az adatvonal L szintjre.
    WAIT_1US	3          ;5usec kivrs. 
    RRNCF   BYTE           ;Adatbyteot eggyel jobbra lpteti.
    OFF	    BYTE,7         ;Trli adatbyte 7. bitjt.
    BTFSC   PORTA,0        ;jra megvizsglja az adatvonalat. Ha magas, 
    ON	    BYTE,7         ;1-be vltja adatbyte 7. bitjt, ha alacsony, 
    BTFSS   PORTA,0        ;0-n hagyja. Ezutn vr, mg az adatvonal jra
    GOTO    $-2            ;magas lessz.
    DECFSZ  CIKLUS         ;Levon 1-et ciklusszmllbl. Ha nem 0, ciklus
    GOTO    UT_VAR         ;elejre ugrik.
    ;---------------
;Utasts dekdolsa
    MOVLW   0xFA
    CPFSEQ  BYTE
    GOTO    $+6
    GOTO    SZOVEG_ERKEZIK
    MOVLW   0xFB
    CPFSEQ  BYTE
    GOTO    $+6
    GOTO    KARAKTER_ERKEZIK
    MOVLW   0xFC
    CPFSEQ  BYTE
    GOTO    $+6
    GOTO    EGYEDI_KARAKTEREK_ERKEZNEK    
    MOVLW   0xEA
    CPFSEQ  BYTE
    GOTO    $+6
    CALL    FENYERO
    MOVLW   0xEB
    CPFSEQ  BYTE
    GOTO    $+0xA
    CALL    NYUGTAZAS
    CALL    LCD_INI
    MOVLW   0xEC
    CPFSEQ  BYTE
    GOTO    $+6
    CALL    LCD_KI
    MOVLW   0xEE
    CPFSEQ  BYTE
    GOTO    $+6
    CALL    KULD_GOMBOK    
    MOV	    OSCCON,B'01000010' ;rajel visszalltsa
    CLRF    TMR0
    GOTO    MAIN             ;Vissza a program elejre
;-----------------------Szveg vtele, feldolgozsa-----------------------------
SZOVEG_ERKEZIK    
    MOVLW   0x25
    MOVWF   FSR1L
    CLRF    FSR1H
    MOV	    CIKLUS,D'8'    ;Ciklusszmll feltltse
    ;---------------
SZ_VAR                     ;Szveg byte fogadsa
    BTFSC   PORTA,0
    GOTO    $-2            ;Vrakozs az adatvonal L szintjre.
    WAIT_1US	3          ;5usec kivrs. 
    RRNCF   BYTE           ;Adatbyteot eggyel jobbra lpteti.
    OFF	    BYTE,7         ;Trli adatbyte 7. bitjt.
    BTFSC   PORTA,0        ;jra megvizsglja az adatvonalat. Ha magas, 
    ON	    BYTE,7         ;1-be vltja adatbyte 7. bitjt, ha alacsony, 
    BTFSS   PORTA,0        ;0-n hagyja. Ezutn vr, mg az adatvonal jra
    GOTO    $-2            ;magas lessz.
    DECFSZ  CIKLUS         ;Levon 1-et ciklusszmllbl. Ha nem 0, ciklus
    GOTO    SZ_VAR         ;elejre ugrik.
    ;---------------    
    MOVLW   0xCC
    CPFSEQ  BYTE           ;Ellen?rzi a berkezett kdot. Ha ez nem a lezr
    GOTO    $+6            ;kd, akkor berja a RAM megfelel? helyre, jra
    GOTO    $+0x10         ;feltlti a ciklusszmllt, s visszatr a rutin
    MOVFF   BYTE,POSTINC1  ;elejre.
    MOV	    CIKLUS,D'8'    ;Ciklusszmll feltltse
    GOTO    SZ_VAR   
    CALL    NYUGTAZAS    
    MOVLW   0x1
    MOVWF   FSR0L
    CLRF    FSR0H
    MOVLW   0x25
    MOVWF   FSR1L
    CLRF    FSR1H    
    MOV	    CIKLUS,D'32'    ;Ciklusszmll feltltse
SZOVEG_ATTOLT    
    MOVFF   POSTINC1,POSTINC0
    DECFSZ  CIKLUS
    GOTO    SZOVEG_ATTOLT  
    MOV	    CIKLUS,D'70'    ;Ciklusszmll feltltse  
TAROLO_TORLESE
    MOVLW   0x25
    MOVWF   FSR1L
    CLRF    FSR1H 
    MOVLW   0x14
    MOVWF   POSTINC1
    DECFSZ  CIKLUS
    GOTO    $-4  
    MOV	    OSCCON,B'01000010' ;rajel visszalltsa
    CLRF    TMR0
    GOTO    MAIN             ;Vissza a program elejre              
;-------------------------Karakter vtele, feldolgozsa-------------------------
KARAKTER_ERKEZIK
    MOVLW   0x1
    MOVWF   FSR2L
    CLRF    FSR2H
    MOV	    CIKLUS,D'8'    ;Ciklusszmll feltltse
    ;---------------
POS_VAR                    ;Pozci byte fogadsa
    BTFSC   PORTA,0
    GOTO    $-2            ;Vrakozs az adatvonal L szintjre.
    WAIT_1US	3          ;5usec kivrs. 
    RRNCF   BYTE           ;Adatbyteot eggyel jobbra lpteti.
    OFF	    BYTE,7         ;Trli adatbyte 7. bitjt.
    BTFSC   PORTA,0        ;jra megvizsglja az adatvonalat. Ha magas, 
    ON	    BYTE,7         ;1-be vltja adatbyte 7. bitjt, ha alacsony, 
    BTFSS   PORTA,0        ;0-n hagyja. Ezutn vr, mg az adatvonal jra
    GOTO    $-2            ;magas lessz.
    DECFSZ  CIKLUS         ;Levon 1-et ciklusszmllbl. Ha nem 0, ciklus
    GOTO    POS_VAR        ;elejre ugrik.
    ;---------------         
    MOVF    BYTE,W
    ADDWF   FSR2L
    MOV	    CIKLUS,D'8'    ;Ciklusszmll feltltse
    ;---------------
K_VAR                      ;Karakter byte fogadsa
    BTFSC   PORTA,0
    GOTO    $-2            ;Vrakozs az adatvonal L szintjre.
    WAIT_1US	3          ;5usec kivrs. 
    RRNCF   BYTE           ;Adatbyteot eggyel jobbra lpteti.
    OFF	    BYTE,7         ;Trli adatbyte 7. bitjt.
    BTFSC   PORTA,0        ;jra megvizsglja az adatvonalat. Ha magas, 
    ON	    BYTE,7         ;1-be vltja adatbyte 7. bitjt, ha alacsony, 
    BTFSS   PORTA,0        ;0-n hagyja. Ezutn vr, mg az adatvonal jra
    GOTO    $-2            ;magas lessz.
    DECFSZ  CIKLUS         ;Levon 1-et ciklusszmllbl. Ha nem 0, ciklus
    GOTO    K_VAR          ;elejre ugrik.
    ;---------------   
    MOVLW   0xCC
    CPFSEQ  BYTE           ;Ellen?rzi a berkezett kdot. Ha ez nem a lezr
    GOTO    $+6            ;kd, akkor berja a RAM megfelel? helyre, jra
    GOTO    $+0x10         ;feltlti a ciklusszmllt, s visszatr a rutin
    MOVFF   BYTE,POSTINC2  ;elejre.
    MOV	    CIKLUS,D'8'    ;Ciklusszmll feltltse
    GOTO    K_VAR    
    CALL    NYUGTAZAS
    MOV	    OSCCON,B'01000010' ;rajel visszalltsa
    CLRF    TMR0
    GOTO    MAIN             ;Vissza a program elejre    
;--------------------Egyedi karakterek fogadsa, feltltse---------------------
EGYEDI_KARAKTEREK_ERKEZNEK
    MOVLW   0x25
    MOVWF   FSR1L
    CLRF    FSR1H
    MOV	    CIKLUS,D'8'    ;Ciklusszmll feltltse
    ;---------------
EK_VAR                     ;Egyedi karakter byte fogadsa
    BTFSC   PORTA,0
    GOTO    $-2            ;Vrakozs az adatvonal L szintjre.
    WAIT_1US	3          ;5usec kivrs. 
    RRNCF   BYTE           ;Adatbyteot eggyel jobbra lpteti.
    OFF	    BYTE,7         ;Trli adatbyte 7. bitjt.
    BTFSC   PORTA,0        ;jra megvizsglja az adatvonalat. Ha magas, 
    ON	    BYTE,7         ;1-be vltja adatbyte 7. bitjt, ha alacsony, 
    BTFSS   PORTA,0        ;0-n hagyja. Ezutn vr, mg az adatvonal jra
    GOTO    $-2            ;magas lessz.
    DECFSZ  CIKLUS         ;Levon 1-et ciklusszmllbl. Ha nem 0, ciklus
    GOTO    EK_VAR         ;elejre ugrik.
    ;---------------  
    MOVLW   0xCC
    CPFSEQ  BYTE           ;Ellen?rzi a berkezett kdot. Ha ez nem a lezr
    GOTO    $+6            ;kd, akkor berja a RAM megfelel? helyre, jra
    GOTO    $+0x10         ;feltlti a ciklusszmllt, s visszatr a rutin
    MOVFF   BYTE,POSTINC1  ;elejre.
    MOV	    CIKLUS,D'8'    ;Ciklusszmll feltltse
    GOTO    EK_VAR
    CALL    NYUGTAZAS
    NOP
    MOV	    OSCCON,B'01000010' ;rajel visszalltsa 
    CLRF    TMR0
    NOP
    MOVLW   0x25           ;Visszaltja a ramkezel?t a kezd?cmre.
    MOVWF   FSR1L
    CLRF    FSR1H    
    MOV	    CIKLUS,D'64'    ;Ciklusszmll feltltse
    ;Egyedi karakterek feltltse
    UTASITAS                ;tkapcsolja a kijelz?t adat fogadsra.
    MOVLW   B'01000000'     ; Karaktergenertor kezd?cme
    CALL    KIIRAS    
    ADAT                    ;Visszakapcsolja adat fogadsra.
EK_ATTOLT    
    MOVF    POSTINC1,W      ;A ramban trolt adatokat ttlti a kijelz?be.
    CALL    KIIRAS
    DECFSZ  CIKLUS
    GOTO    EK_ATTOLT  
    MOV	    CIKLUS,D'70'    ;Ciklusszmll feltltse    
    MOVLW   0x25
    MOVWF   FSR1L
    CLRF    FSR1H           
    MOVLW   0x14
    MOVWF   POSTINC1
    DECFSZ  CIKLUS
    GOTO    $-4
    CLRF    TMR0
    GOTO    MAIN             ;Vissza a program elejre         
;-------------------------Gombinformcik elkldse-----------------------------
KULD_GOMBOK   
    MOV	    CIKLUS,D'8'
KG_1     
    BTFSC   PORTA,0
    GOTO    $-2            ;Vrakozs az adatvonal L szintjre.
    BTFSS   BKT_1,0        ;Els? billenty?kd 0. bitjnek ellen?rzse.
    OFF	    PORTA,1        ;Ha 0, lehzza az adatvonalat L-re.
    WAIT_1US	8          ;8usec vrakozs.
    ON	    PORTA,1        ;Adatvonal vissza H-ra.
    RRNCF   BKT_1          ;Els? billenty?kd jobbra lptetse.
    DECFSZ  CIKLUS         ;Ciklusszmllbl kivon 1-et.
    GOTO    KG_1           ;Ha nem 0, vissza a ciklus elejre
    MOV	    CIKLUS,D'8'
KG_2     
    BTFSC   PORTA,0
    GOTO    $-2            ;Vrakozs az adatvonal L szintjre.
    BTFSS   BKT_2,0        ;Msodik billenty?kd 0. bitjnek ellen?rzse.
    OFF	    PORTA,1        ;Ha 0, lehzza az adatvonalat L-re.
    WAIT_1US	8          ;8usec vrakozs.
    ON	    PORTA,1        ;Adatvonal vissza H-ra.
    RRNCF   BKT_2          ;Msodik billenty?kd jobbra lptetse.
    DECFSZ  CIKLUS         ;Ciklusszmllbl kivon 1-et.
    GOTO    KG_2           ;Ha nem 0, vissza a ciklus elejre       
    MOV	    CIKLUS,D'8'
KG_3     
    BTFSC   PORTA,0
    GOTO    $-2            ;Vrakozs az adatvonal L szintjre.
    BTFSS   BKT_3,0        ;Harmadik billenty?kd 0. bitjnek ellen?rzse.
    OFF	    PORTA,1        ;Ha 0, lehzza az adatvonalat L-re.
    WAIT_1US	8          ;8usec vrakozs.
    ON	    PORTA,1        ;Adatvonal vissza H-ra.
    RRNCF   BKT_3          ;Harmadik billenty?kd jobbra lptetse.
    DECFSZ  CIKLUS         ;Ciklusszmllbl kivon 1-et.
    GOTO    KG_3           ;Ha nem 0, vissza a ciklus elejre    
    GOTO    NYUGTAZAS    
;---------------------------Fnyer? vltoztats---------------------------------    
FENYERO
    MOV	    CIKLUS,D'8'    ;Ciklusszmll feltltse
    ;---------------
FENY_VAR                   ;Fnyer? szablyz byte fogadsa
    BTFSC   PORTA,0
    GOTO    $-2            ;Vrakozs az adatvonal L szintjre.
    WAIT_1US	3          ;5usec kivrs. 
    RRNCF   BYTE           ;Adatbyteot eggyel jobbra lpteti.
    OFF	    BYTE,7         ;Trli adatbyte 7. bitjt.
    BTFSC   PORTA,0        ;jra megvizsglja az adatvonalat. Ha magas, 
    ON	    BYTE,7         ;1-be vltja adatbyte 7. bitjt, ha alacsony, 
    BTFSS   PORTA,0        ;0-n hagyja. Ezutn vr, mg az adatvonal jra
    GOTO    $-2            ;magas lessz.
    DECFSZ  CIKLUS         ;Levon 1-et ciklusszmllbl. Ha nem 0, ciklus
    GOTO    FENY_VAR       ;elejre ugrik.
    ;---------------  
    MOVFF    BYTE,CCPR1L   ;Berja a kapott adatot a PWM kitltsbe.
    CALL    NYUGTAZAS
    RETURN        
;-----------------------------------LCD ki--------------------------------------
LCD_KI
    CLRF    LATB           ;Trli az sszes LCD-hez kapcsold kimenetet,
    UTASITAS               ;s lekapcsolja a httrvilgtst.
    OFF	    ENABLE
    OFF	    LCD
    OFF	    PSTRCON,3
;-------------------------------Vtel nyugtzsa--------------------------------
NYUGTAZAS
    MOV	    CIKLUS,D'8'
    MOV	    BYTE,0xAA
NY_S     
    BTFSC   PORTA,0
    GOTO    $-2            ;Vrakozs az adatvonal L szintjre.
    BTFSS   BYTE,0        ;Els? billenty?kd 0. bitjnek ellen?rzse.
    OFF	    PORTA,1        ;Ha 0, lehzza az adatvonalat L-re.
    WAIT_1US	8          ;8usec vrakozs.
    ON	    PORTA,1        ;Adatvonal vissza H-ra.
    RRNCF   BYTE          ;Els? billenty?kd jobbra lptetse.
    DECFSZ  CIKLUS         ;Ciklusszmllbl kivon 1-et.
    GOTO    NY_S           ;Ha nem 0, vissza a ciklus elejre    
    RETURN
;----------------------------Kijelz? inicializlsa-----------------------------
LCD_INI 
    MOV	    OSCCON,B'01000010' ;rajel visszalltsa
    NOP
    OFF     ENABLE              ;Bers tiltsa
    ON	    LCD
    ON	    PSTRCON,3 
    DELAY   D'250'
    DELAY   D'250'
    DELAY   D'250'
    DELAY   D'250'
    DELAY   D'250'
    DELAY   D'250'
    DELAY   D'250'
    DELAY   D'250'
    UTASITAS             ;Belltjuk a kijelz? R/S bemenett utasts fogadsra
    MOVLW	B'00110000'        ;Ez az utasts 4x vgrehajtva reseteli az LCD-t
    CALL    KIIRAS0
    CALL    KIIRAS0
    CALL    KIIRAS0
    CALL    KIIRAS0
    DELAY   D'250'             ;Nmi kivrs utn be kell lltani a kijelz?t.
    MOVLW	B'00100000'
    CALL    KIIRAS0            ;Itt kapcsolunk t 4 bites zemmdra
    MOVLW	B'00101000'       ;Mr 4 bites mdban belltjuk a
    CALL    KIIRAS            ; kijelz?t ktsorsa
    MOVLW	B'00001100'       ;Kijelz? engedlyezse
    CALL    KIIRAS
                ;kezetes karakterek feltltse
    MOVLW   B'01000000'             ; Karaktergenertor kezd?cme
    CALL    KIIRAS
    ADAT
    MOVLW   B'00000010'
    CALL    KIIRAS
    MOVLW   B'00000100'
    CALL    KIIRAS
    MOVLW   B'00001110'
    CALL    KIIRAS
    MOVLW   B'00000001'
    CALL    KIIRAS                   ; (0)
    MOVLW   B'00001111'
    CALL    KIIRAS
    MOVLW   B'00010001'
    CALL    KIIRAS
    MOVLW   B'00001111'
    CALL    KIIRAS
    MOVLW   B'00000000'
    CALL    KIIRAS                   ;-----------------------------------
    MOVLW   B'00000010'
    CALL    KIIRAS
    MOVLW   B'00000100'
    CALL    KIIRAS
    MOVLW   B'00001110'
    CALL    KIIRAS
    MOVLW   B'00010001'
    CALL    KIIRAS                   ; (1)
    MOVLW   B'00011111'
    CALL    KIIRAS
    MOVLW   B'00010000'
    CALL    KIIRAS
    MOVLW   B'00001110'
    CALL    KIIRAS
    MOVLW   B'00000000'
    CALL    KIIRAS                   ;-----------------------------------
    MOVLW   B'00000010'
    CALL    KIIRAS
    MOVLW   B'00000100'
    CALL    KIIRAS
    MOVLW   B'00000000'
    CALL    KIIRAS
    MOVLW   B'00001100'
    CALL    KIIRAS                   ; (2)
    MOVLW   B'00000100'
    CALL    KIIRAS
    MOVLW   B'00000100'
    CALL    KIIRAS
    MOVLW   B'00001110'
    CALL    KIIRAS
    MOVLW   B'00000000'
    CALL    KIIRAS                   ;-----------------------------------    
    MOVLW   B'00000010'
    CALL    KIIRAS
    MOVLW   B'00000100'
    CALL    KIIRAS
    MOVLW   B'00000000'
    CALL    KIIRAS
    MOVLW   B'00001110'
    CALL    KIIRAS                   ; (3)
    MOVLW   B'00010001'
    CALL    KIIRAS
    MOVLW   B'00010001'
    CALL    KIIRAS
    MOVLW   B'00001110'
    CALL    KIIRAS
    MOVLW   B'00000000'
    CALL    KIIRAS                   ;-----------------------------------
    MOVLW   B'00000000'
    CALL    KIIRAS
    MOVLW   B'00001010'
    CALL    KIIRAS
    MOVLW   B'00000000'
    CALL    KIIRAS
    MOVLW   B'00001110'
    CALL    KIIRAS                   ; (4)
    MOVLW   B'00010001'
    CALL    KIIRAS
    MOVLW   B'00010001'
    CALL    KIIRAS
    MOVLW   B'00001110'
    CALL    KIIRAS
    MOVLW   B'00000000'
    CALL    KIIRAS                   ;-----------------------------------
    MOVLW   B'00000101'
    CALL    KIIRAS
    MOVLW   B'00001010'
    CALL    KIIRAS
    MOVLW   B'00000000'
    CALL    KIIRAS
    MOVLW   B'00001110'
    CALL    KIIRAS                   ;? (5)
    MOVLW   B'00010001'
    CALL    KIIRAS
    MOVLW   B'00010001'
    CALL    KIIRAS
    MOVLW   B'00001110'
    CALL    KIIRAS
    MOVLW   B'00000000'
    CALL    KIIRAS                   ;-----------------------------------
    MOVLW   B'00000000'
    CALL    KIIRAS
    MOVLW   B'00001010'
    CALL    KIIRAS
    MOVLW   B'00000000'
    CALL    KIIRAS
    MOVLW   B'00010001'
    CALL    KIIRAS                   ; (6)
    MOVLW   B'00010001'
    CALL    KIIRAS
    MOVLW   B'00010001'
    CALL    KIIRAS
    MOVLW   B'00001110'
    CALL    KIIRAS
    MOVLW   B'00000000'
    CALL    KIIRAS                   ;----------------------------------- 
    MOVLW   B'00000101'
    CALL    KIIRAS
    MOVLW   B'00001010'
    CALL    KIIRAS
    MOVLW   B'00000000'
    CALL    KIIRAS
    MOVLW   B'00010001'
    CALL    KIIRAS                   ;? (7)
    MOVLW   B'00010001'
    CALL    KIIRAS
    MOVLW   B'00010001'
    CALL    KIIRAS
    MOVLW   B'00001110'
    CALL    KIIRAS
    MOVLW   B'00000000'
    CALL    KIIRAS                   ;-----------------------------------     
    RETURN
;-----------------------------Kirs rutin--------------------------------------
KIIRAS
    MOVWF   KAR_KOD            ;Wreg ttltse KAR_KOD-ba
    MOVFF   KAR_KOD,LATB       ;KAR_KOD LATB-be tltse(Csak a fels? 4 bit)
    DELAY   D'2'               ;El? vrakozs
    ON      ENABLE             ;Bers indul
    DELAY   D'4'               ;Kivrs
    OFF     ENABLE             ;Bers vge
    SWAPF   KAR_KOD            ;Megcserli KAR_KOD els? s msodik 4-4 bitjt
    MOVFF   KAR_KOD,LATB       ;KAR_KOD LATB-be tltse(Csak a fels? 4 bit)
    DELAY   D'2'               ;El? vrakozs
    ON      ENABLE             ;Bers indul
    DELAY   D'4'               ;Kivrs
    OFF     ENABLE             ;Bers vge
    RETURN
KIIRAS0                        ;Kijelz? reszetelsekor  hasznlatos
    MOVWF   LATB               ;Karakter b-be tltse
    DELAY   D'2'               ;El? vrakozs
    ON      ENABLE             ;Bers indul
    DELAY   D'4'               ;Kivrs
    OFF     ENABLE             ;Bers vge
    RETURN
;-----------------------------dvzl? szveg------------------------------------    
UDVOZLOSZOVEG
    CLRF    TBLPTRU               ;Betlti a tblzatkezel?be A szveg
    MOVLW   LOW SZOVEG            ;kezd?pontjnak cmt.
    MOVWF   TBLPTRL                 
    MOVLW   HIGH SZOVEG           
    MOVWF   TBLPTRH      
    MOVLW   0x01
    MOVWF   FSR0L
    CLRF    FSR0H
    MOV	    CIKLUS,D'32'  
USZ
    TBLRD*+                       ;tmsolja az adatokat a RAM-ba.
    MOVFF   TABLAT,POSTINC0
    DECFSZ  CIKLUS
    GOTO    USZ
    RETURN   
SZOVEG
    DB		"Zink Electronic System  (Z.E.S.)"
    RETURN
;-------------------------------------------------------------------------------
GOMB_KIIR    
    MOVLW   D'25'
    MOVWF   FSR0L
    CLRF    FSR0H
    MOVLW   0x20
    CPFSEQ  BKT_1
    GOTO    GK1
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    RETURN
GK1
    MOVLW   0x23
    CPFSEQ  BKT_1
    GOTO    GK2
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x32
    MOV	    POSTINC0,0x33
    RETURN    
GK2
    MOVLW   0x2A
    CPFSEQ  BKT_1
    GOTO    GK3
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x32
    MOV	    POSTINC0,0x41
    RETURN  
GK3
    MOVLW   0x2B
    CPFSEQ  BKT_1
    GOTO    GK4
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x32
    MOV	    POSTINC0,0x42
    RETURN 
GK4
    MOVLW   0x2C
    CPFSEQ  BKT_1
    GOTO    GK5
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x32
    MOV	    POSTINC0,0x43
    RETURN   
GK5
    MOVLW   0x2D
    CPFSEQ  BKT_1
    GOTO    GK6
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x32
    MOV	    POSTINC0,0x44
    RETURN     
GK6
    MOVLW   0x2E
    CPFSEQ  BKT_1
    GOTO    GK7
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x32
    MOV	    POSTINC0,0x45
    RETURN   
GK7
    MOVLW   0x30
    CPFSEQ  BKT_1
    GOTO    GK8
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x33
    MOV	    POSTINC0,0x30
    RETURN    
GK8
    MOVLW   0x31
    CPFSEQ  BKT_1
    GOTO    GK9
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x33
    MOV	    POSTINC0,0x31
    RETURN   
GK9
    MOVLW   0x32
    CPFSEQ  BKT_1
    GOTO    GK10
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x33
    MOV	    POSTINC0,0x32
    RETURN    
GK10
    MOVLW   0x33
    CPFSEQ  BKT_1
    GOTO    GK11
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x33
    MOV	    POSTINC0,0x33
    RETURN    
GK11
    MOVLW   0x34
    CPFSEQ  BKT_1
    GOTO    GK12
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x33
    MOV	    POSTINC0,0x34
    RETURN    
GK12
    MOVLW   0x35
    CPFSEQ  BKT_1
    GOTO    GK13
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x33
    MOV	    POSTINC0,0x35
    RETURN    
GK13
    MOVLW   0x36
    CPFSEQ  BKT_1
    GOTO    GK14
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x33
    MOV	    POSTINC0,0x36
    RETURN    
GK14
    MOVLW   0x37
    CPFSEQ  BKT_1
    GOTO    GK15
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x33
    MOV	    POSTINC0,0x37
    RETURN    
GK15
    MOVLW   0x38
    CPFSEQ  BKT_1
    GOTO    GK16
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x33
    MOV	    POSTINC0,0x38
    RETURN    
GK16
    MOVLW   0x39
    CPFSEQ  BKT_1
    GOTO    GK17
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x20
    MOV	    POSTINC0,0x33
    MOV	    POSTINC0,0x39
    RETURN    
GK17
    RETURN
;------------------------------------------------------------------------------- 
MEGSZAKITAS
    OFF	    INTCON,2
    POP
    POP
    ON	    INTCON,7
    MOV	    OSCCON,B'01000010' ;rajel visszalltsa
    CLRF    TMR0
    GOTO    MAIN             ;Vissza a program elejre   
;-------------------------------------------------------------------------------
;-------------------------------------------------------------------------------
SZAMBONTAS_16
    CLRF    HE1
    CLRF    HE2
    CLRF    HE3
    CLRF    HE4
    CLRF    HE5
    INCF    HE5
    MOVLW   H'10'
    SUBWF   BONTANDOL,F
    MOVLW   H'27'
    SUBWFB  BONTANDOH,F
    CLRF    WREG
    SUBWFB  BONTANDOU,F
    BC      $-0xE
    DECF    HE5
    MOVLW   H'10'
    ADDWF   BONTANDOL,F
    MOVLW   H'27'
    ADDWFC  BONTANDOH
    INCF    HE4
    MOVLW   H'E8'
    SUBWF   BONTANDOL,F
    MOVLW   H'03'
    SUBWFB  BONTANDOH,F
    BC      $-0xA
    DECF    HE4
    MOVLW   H'E8'
    ADDWF   BONTANDOL,F
    MOVLW   H'03'
    ADDWFC  BONTANDOH    
    INCF    HE3
    MOVLW   H'64'
    SUBWF   BONTANDOL,F
    MOVLW   H'0'
    SUBWFB  BONTANDOH,F
    BC      $-0xA
    DECF    HE3
    MOVLW   H'64'
    ADDWF   BONTANDOL,F
    INCF    HE2
    MOVLW   H'0A'
    SUBWF   BONTANDOL,F
    BC      $-6
    DECF    HE2
    MOVLW   H'0A'
    ADDWF   BONTANDOL,W
    MOVWF   HE1   
    RETURN	
;-------------------------------------------------------------------------------    
    END
    ;--Az ad oldal m?kdse:--
    ;Az ads egy 50usec-es alacsony jel kikldsvel kezd?dik. Ezutn az ad
    ;vr 15usec-ig, majd megnzi sz adatvonalat. Ha magas, vr 50usec-et, majd
    ;jra kldi az indt jelet. Ha alacsony, vr 30usec-ig, majd megkezdi az
    ;els? adat, a parancs elkldst. A klds sorn ha logikai 1-et kld,
    ;akkor 2usec-ig lehzza az adatvonalat 0-ra, majd vr 8usec-et. Ezutn 
    ;kszti el? a kvetkez? bitet, s indtja jra az adst. Logikai 0-t
    ;gy kld, hogy 8usec-ig lehzza az adatvonalat, majd vr 2usec-et. 
    ;Minden byte kldst a 0-s bittel kell kezdeni.
    ;Ha tment a parancs 8 bitje, vr 10usec-et, hogy a vev? a parancsot 
    ;feldolgozza. Ezutn kldi az adatokat. Kt adat kldse kztt kell 3usec
    ;sznetet tartani. Ebbe beleszmt az ad oldal kvetkez? byte 
    ;el?ksztsnek ideje is. gy egy byte kldsi ideje 83usec.
    ;Minden olyan esetben, amikor van lezr kd, a vev? visszakld az adnak
    ;egy AA kdot. Ez a nyugtzs. Teht a lezr kd elkldse utn az adnak
    ;vtelre kell kapcsolnia.
    ;Parancsok fajti:
    ;Kd: FA    Szveget kldk.    
    ;A szveg 32 byte-bl ll. a 33. byte a lezr kd, a CC
    ;Kd: FB    Karakter(eke)t kldk.
    ;Az els? byte 1-32-ig szm lehet, ami a karakter helyt hatrozza meg a 
    ;kijelz?n. Az elkldhet? karakterek szmt a kezd? karakter helye hatrozza
    ;meg. Zrsknt itt is kell lezr kdot kldeni. (CC)
    ;Kd: FC    Egyedi karaktereket kldk.
    ;A CG RAM llomny feltltsre szolgl. Nem muszly mind a 8 karaktert
    ;feltlteni, de minden esetben a 0-s karakterhellyel kezd?dik a bers.
    ;Itt is kell lezr kd. (CC) 
    ;Kd: EA     Fnyer? szablyzs. 
    ;Kldend? a parancs utn mindssze 1 byte. (0-255) a httrvilgts 
    ;belltsra szolgl. Lezr kd nincs.
    ;Kd: EB     LCD bekapcsolsa.   Csak parancs.    
    ;Kd: EC     LCD kikapcsolsa.   Csak parancs.
    ;Kd: EE     Gomb rtkeket vrok.
    ;A parancs kiadsa utn vr 10usec-et, hogy a vev? felkszlhessen az 
    ;adatkldsre. Ezutn az adatvonalat 2usec-re lehzza, majd vr 3usec-et
    ;s megnzi az adatvonalat. Ha alacsony, 0-t r a trolba, ha magas, 1-et.
    ;Ezutn vr 5usec-et, majd folytatja. sszesen 3 byte adat fog jnni.
    ;Ezen adatok 0-16-ig szmokat tartalmazhatnak. gy maximum 3 gomb egyidej?
    ;lenyomsa rzkelhet?. A mtrixon bel?l, ha a gombok nincsenek didkkal
    ;levlasztva, akkor csak az eltr? adatsinen lv? gombokat lehet egyszerre
    ;lenyomni. (Adatsn= ahol a jel visszatr a PIC-be.) 